//+------------------------------------------------------------------+
//|                                              CSyncEvent Test.mq4 |
//|                                     Copyright 2017, S.Aukscionis |
//+------------------------------------------------------------------+
#property copyright "2017, S.Aukscionis"
#property strict

#include <CSyncEvent.mqh>
CSyncEvent Event;
CSyncEventState EventState;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
   int handles[1];

   handles[0]=Event.Create("Local\\event.356G8924t26fD7e10G64");

   if(handles[0]!=NULL) Print("Event created");
   else Print("Event create error ",kernel32::GetLastError());

   Print("Memory was filled with data");

   if(Event.Set()) Print("Event set");
   else Print("Event set error ",kernel32::GetLastError());

   Print("Waiting for event state to become signaled");

   int result=EventState.Get(handles);

   if(result>=NULL && result<=ArraySize(handles)-1) Print("Event state became signaled");
   else Print("Waiting error ",kernel32::GetLastError());

   Print("Memory was emptied");

   if(Event.Reset()) Print("Event reset");
   else Print("Event reset error ",kernel32::GetLastError());

   if(Event.Destroy()) Print("Event destroyed");
   else Print("Event destroy error ",kernel32::GetLastError());
  }
//+------------------------------------------------------------------+
